#include "WorldPosToHeightMap.fxh"

#define TERRAIN_TEXTURE_SCALE 0.5		// Maps from world position to terrain texture coordinate. Simple scalar.
#define TERRAIN_HEIGHT_SCALE 3			// Maps sampled height to world units

float2 HeightMapTexelSize;				// 1/resolution. Except it doesn't need to be the actual resolution.

#define HEIGHTMAP_REGISTER(_a) \
	texture HeightMapTexture : register(t##_a); \
	sampler2D HeightMapSampler : register(s##_a) = sampler_state \
{ \
	Texture = <HeightMapTexture>; \
}; \
	\
float GetWorldHeight(float3 worldPosition) \
{ \
	float heightValue = tex2Dlod(HeightMapSampler, float4(WorldPositionToHeightMapTexCoord(worldPosition), 0, 0)).r;  \
	heightValue -= 0.5; \
	return TERRAIN_HEIGHT_SCALE * heightValue; \
}

float2 WorldPositionToTerrainTextureCoord(float3 worldPosition)
{
	return worldPosition.xz * TERRAIN_TEXTURE_SCALE;
}