float4x4 World;
float4x4 View;
float4x4 Projection;
float4 WorldToFlowMapTexCoord;
float2 SquareSize;

bool UsingUnsignedFlowMap = true;

texture FlowMapTexture : register(t0);
sampler2D FlowMapSampler : register(s0) = sampler_state
{
	Texture = <FlowMapTexture>;
};

struct VertexShaderInput
{
    float4 Position : POSITION0;
	float4 Color : COLOR0;
    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
	float4 Color : COLOR0;
};

#define A_BIT_ABOVE_WATER 0.01

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output;

	float extendAmount = input.Position.y;

    float4 worldPosition = mul(input.Position, World);

	// Sample flow
	float2 texCoord = (worldPosition.xz + WorldToFlowMapTexCoord.xy) * WorldToFlowMapTexCoord.zw;
	float2 flowVector = tex2Dlod(FlowMapSampler, float4(texCoord, 0, 0)).rg;

	if (UsingUnsignedFlowMap)
	{
		flowVector = (flowVector * 2) - 1;
	}
	worldPosition.xz -= flowVector * SquareSize * extendAmount;

	worldPosition.y = A_BIT_ABOVE_WATER;

    float4 viewPosition = mul(worldPosition, View);
    output.Position = mul(viewPosition, Projection);
	output.Color = input.Color;

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
    return input.Color;
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_3_0 VertexShaderFunction();
        PixelShader = compile ps_3_0 PixelShaderFunction();
    }
}
