﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace WaterTest
{
    class Terrain
    {
        private const float TextureExpansion = 5;

        public Terrain(Game game, HeightMap heightMap, Camera camera)
        {
            this.camera = camera;
            this.heightMap = heightMap;
            device = game.GraphicsDevice;
            terrainEffect = game.Content.Load<Effect>(@"Fx\TerrainEffect");
            terrainEffect.Parameters["TerrainTexture"].SetValue(game.Content.Load<Texture2D>(@"Textures\grass"));
            terrainEffect.Parameters["UnderWaterTerrainTexture"].SetValue(game.Content.Load<Texture2D>(@"Textures\dirt"));
        }

        HeightMap heightMap;
        Camera camera;
        GraphicsDevice device;
        Effect terrainEffect;

        public void Draw()
        {
            device.VertexSamplerStates[0] = SamplerState.PointClamp;

            device.DepthStencilState = DepthStencilState.Default;
            device.BlendState = BlendState.Opaque;

            heightMap.SetEffectParametersBeforeDraw(terrainEffect);

            //device.RasterizerState = wireFrame;

            terrainEffect.Parameters["World"].SetValue(Matrix.Identity);
            terrainEffect.Parameters["View"].SetValue(camera.View);
            terrainEffect.Parameters["Projection"].SetValue(camera.Projection);
            terrainEffect.Parameters["DirectionToLight"].SetValue(SunPosition);
            terrainEffect.CurrentTechnique.Passes[0].Apply();

            heightMap.Draw();

            device.RasterizerState = RasterizerState.CullCounterClockwise;
        }

        public Vector3 SunPosition { get; set; }

        /*
        private static RasterizerState wireFrame = new RasterizerState()
        {
            FillMode = FillMode.WireFrame,
            CullMode = CullMode.CullCounterClockwiseFace,
        };*/
    }
}
